/*
 * Decompiled with CFR 0.152.
 */
package io.github.jamalam360.rightclickharvest;

import com.mojang.logging.LogUtils;
import io.github.jamalam360.rightclickharvest.RightClickHarvestCallbacks;
import io.github.jamalam360.rightclickharvest.config.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;

@Mod(value="rightclickharvest")
public class RightClickHarvestModInit {
    public static final String MOD_ID = "rightclickharvest";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final Pair<Config, ForgeConfigSpec> CONFIG = new ForgeConfigSpec.Builder().configure(Config::new);
    public static final Direction[] CARDINAL_DIRECTIONS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    @Deprecated(forRemoval=true)
    public static final TagKey<Block> HOE_REQUIRED = BlockTags.create((ResourceLocation)new ResourceLocation("rightclickharvest", "hoe_required"));
    public static final TagKey<Block> HOE_NEVER_REQUIRED = BlockTags.create((ResourceLocation)new ResourceLocation("rightclickharvest", "hoe_never_required"));
    public static final TagKey<Block> RADIUS_HARVEST_BLACKLIST = BlockTags.create((ResourceLocation)new ResourceLocation("rightclickharvest", "radius_harvest_blacklist"));
    public static final TagKey<Item> LOW_TIER_HOES = ItemTags.create((ResourceLocation)new ResourceLocation("rightclickharvest", "low_tier_hoes"));
    public static final TagKey<Item> MID_TIER_HOES = ItemTags.create((ResourceLocation)new ResourceLocation("rightclickharvest", "mid_tier_hoes"));
    public static final TagKey<Item> HIGH_TIER_HOES = ItemTags.create((ResourceLocation)new ResourceLocation("rightclickharvest", "high_tier_hoes"));

    public RightClickHarvestModInit() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CONFIG.getRight(), "rightclickharvest.toml");
        modEventBus.addListener(this::onCommonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void onCommonSetup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.addListener(this::onBlockUse);
        LOGGER.info("Initialized");
    }

    @SubscribeEvent
    public void onBlockUse(PlayerInteractEvent.RightClickBlock event) {
        InteractionResult res = this.onBlockUse(event.getEntity(), event.getLevel(), event.getHand(), event.getHitVec(), true);
        if (res != InteractionResult.PASS) {
            event.setCanceled(true);
            event.setCancellationResult(res);
        }
    }

    private InteractionResult onBlockUse(Player player, Level world, InteractionHand hand, BlockHitResult hitResult, boolean initialCall) {
        if (player.m_5833_() || hand == InteractionHand.OFF_HAND) {
            return InteractionResult.PASS;
        }
        BlockState state = world.m_8055_(hitResult.m_82425_());
        Block originalBlock = state.m_60734_();
        ItemStack stack = player.m_21120_(hand);
        if (((Config)RightClickHarvestModInit.CONFIG.getLeft()).hungerLevel.get() != Config.HungerLevel.NONE && !player.m_150110_().f_35937_ && player.m_36324_().m_38702_() <= 0) {
            return InteractionResult.PASS;
        }
        if (!state.m_204336_(HOE_NEVER_REQUIRED) && ((Boolean)((Config)RightClickHarvestModInit.CONFIG.getLeft()).requireHoe.get()).booleanValue() && !stack.m_204117_(Tags.Items.TOOLS_HOES)) {
            return InteractionResult.PASS;
        }
        if (!initialCall && state.m_204336_(RADIUS_HARVEST_BLACKLIST)) {
            return InteractionResult.PASS;
        }
        if (state.m_60734_() instanceof CocoaBlock || state.m_60734_() instanceof CropBlock || state.m_60734_() instanceof NetherWartBlock) {
            if (RightClickHarvestModInit.isMature(state)) {
                if (initialCall && ((Boolean)((Config)RightClickHarvestModInit.CONFIG.getLeft()).harvestInRadius.get()).booleanValue() && !state.m_204336_(RADIUS_HARVEST_BLACKLIST) && stack.m_204117_(Tags.Items.TOOLS_HOES)) {
                    int radius = 0;
                    boolean circle = false;
                    if (stack.m_204117_(LOW_TIER_HOES)) {
                        radius = 1;
                        circle = true;
                    } else if (stack.m_204117_(MID_TIER_HOES)) {
                        radius = 1;
                    } else if (stack.m_204117_(HIGH_TIER_HOES)) {
                        radius = 2;
                        circle = true;
                    }
                    if (radius != 0) {
                        if (radius == 1 && circle) {
                            for (Direction dir : CARDINAL_DIRECTIONS) {
                                this.onBlockUse(player, world, hand, hitResult.m_82430_(hitResult.m_82425_().m_121945_(dir)), false);
                            }
                        } else {
                            for (int x = -radius; x <= radius; ++x) {
                                for (int z = -radius; z <= radius; ++z) {
                                    BlockPos pos = hitResult.m_82425_().m_5487_(Direction.Axis.X, x).m_5487_(Direction.Axis.Z, z);
                                    if (circle && pos.m_123333_((Vec3i)hitResult.m_82425_()) > radius) continue;
                                    this.onBlockUse(player, world, hand, hitResult.m_82430_(pos), false);
                                }
                            }
                        }
                    }
                }
                if (!world.f_46443_) {
                    BlockEvent.BreakEvent breakEv = new BlockEvent.BreakEvent(world, hitResult.m_82425_(), state, player);
                    if (MinecraftForge.EVENT_BUS.post((Event)breakEv)) {
                        return InteractionResult.FAIL;
                    }
                    BlockState replantState = RightClickHarvestModInit.getReplantState(state);
                    BlockEvent.EntityPlaceEvent placeEv = new BlockEvent.EntityPlaceEvent(BlockSnapshot.create((ResourceKey)world.m_46472_(), (LevelAccessor)world, (BlockPos)hitResult.m_82425_()), world.m_8055_(hitResult.m_82425_().m_7495_()), (Entity)player);
                    if (MinecraftForge.EVENT_BUS.post((Event)placeEv)) {
                        return InteractionResult.FAIL;
                    }
                    world.m_46597_(hitResult.m_82425_(), replantState);
                    RightClickHarvestModInit.dropStacks(state, (ServerLevel)world, hitResult.m_82425_(), (Entity)player, player.m_21120_(hand));
                    if (((Boolean)((Config)RightClickHarvestModInit.CONFIG.getLeft()).requireHoe.get()).booleanValue()) {
                        stack.m_41622_(1, (LivingEntity)player, entity -> entity.m_21190_(hand));
                    }
                    player.m_36399_(0.008f * ((Config.HungerLevel)((Object)((Config)RightClickHarvestModInit.CONFIG.getLeft()).hungerLevel.get())).modifier);
                } else {
                    player.m_5496_(state.m_60734_() instanceof NetherWartBlock ? SoundEvents.f_12114_ : SoundEvents.f_11839_, 1.0f, 1.0f);
                }
                RightClickHarvestCallbacks.AfterHarvest.post(player, originalBlock);
                return InteractionResult.SUCCESS;
            }
        } else if (state.m_60734_() instanceof SugarCaneBlock) {
            if (hitResult.m_82434_() == Direction.UP && stack.m_41720_() == Items.f_41909_) {
                return InteractionResult.PASS;
            }
            int count = 1;
            BlockPos bottom = hitResult.m_82425_().m_7495_();
            while (world.m_8055_(bottom).m_60713_(Blocks.f_50130_)) {
                ++count;
                bottom = bottom.m_7495_();
            }
            if (count == 1 && !world.m_8055_(hitResult.m_82425_().m_7494_()).m_60713_(Blocks.f_50130_)) {
                return InteractionResult.PASS;
            }
            if (!world.f_46443_) {
                world.m_46961_(bottom.m_6630_(2), true);
                player.m_36399_(0.008f * ((Config.HungerLevel)((Object)((Config)RightClickHarvestModInit.CONFIG.getLeft()).hungerLevel.get())).modifier);
            } else {
                player.m_5496_(SoundEvents.f_11839_, 1.0f, 1.0f);
            }
            RightClickHarvestCallbacks.AfterHarvest.post(player, originalBlock);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private static boolean isMature(BlockState state) {
        if (state.m_60734_() instanceof CocoaBlock) {
            return (Integer)state.m_61143_((Property)CocoaBlock.f_51736_) >= 2;
        }
        Block block = state.m_60734_();
        if (block instanceof CropBlock) {
            CropBlock cropBlock = (CropBlock)block;
            return cropBlock.m_52307_(state);
        }
        if (state.m_60734_() instanceof NetherWartBlock) {
            return (Integer)state.m_61143_((Property)NetherWartBlock.f_54967_) >= 3;
        }
        return false;
    }

    private static BlockState getReplantState(BlockState state) {
        if (state.m_60734_() instanceof CocoaBlock) {
            return (BlockState)state.m_61124_((Property)CocoaBlock.f_51736_, (Comparable)Integer.valueOf(0));
        }
        Block block = state.m_60734_();
        if (block instanceof CropBlock) {
            CropBlock cropBlock = (CropBlock)block;
            return cropBlock.m_52289_(0);
        }
        if (state.m_60734_() instanceof NetherWartBlock) {
            return (BlockState)state.m_61124_((Property)NetherWartBlock.f_54967_, (Comparable)Integer.valueOf(0));
        }
        return state;
    }

    private static void dropStacks(BlockState state, ServerLevel world, BlockPos pos, Entity entity, ItemStack toolStack) {
        Item replant = state.m_60734_().m_7397_((BlockGetter)world, pos, state).m_41720_();
        boolean[] removedReplant = new boolean[]{false};
        Block.m_49874_((BlockState)state, (ServerLevel)world, (BlockPos)pos, null, (Entity)entity, (ItemStack)toolStack).forEach(stack -> {
            if (!removedReplant[0] && stack.m_41720_() == replant) {
                stack.m_41764_(stack.m_41613_() - 1);
                removedReplant[0] = true;
            }
            Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)stack);
        });
        state.m_222967_(world, pos, toolStack, true);
    }
}

